viewer.mode=FULLSCREEN

function setup()
    tab={}
    ss=27
    assert(OrbitViewer, "Please include Cameras as a dependency")
    scene = craft.scene() 
    v=scene.camera:add(OrbitViewer,vec3(50,50,50), ss, 0, 1000)
    v.rx=45
    v.ry=270
    entity = scene:entity()
    volume = entity:add(craft.volume, 300, 300, 300)
    cube(0,0,0,ss) 
    count=0
    
    setLighting()
end

function setLighting()
    scene.sun.rotation = quat.eulerAngles(45,0,45)   
    scene.ambientColor = color(47)   
    skyMaterial = scene.sky.material
    skyMaterial.horizon = color(84, 208, 201)    
    cameraComponent = scene.camera:get(craft.camera)
    cameraComponent.hdr = true
    cameraComponent.colorTextureEnabled = true
    sunLight = scene.sun:get(craft.light)
    sunLight.intenstity =  800
end

function update(dt)
    scene:update(dt)
end

function draw()
    update(DeltaTime)
    scene:draw() 
    show()
    collectgarbage()
end

function show()
    if count>=#tab then return end
    count=count+1
    volume:set(tab[count].x,tab[count].y,tab[count].z, 'name', 'solid', 'color',                             color(math.random(100, 255),math.random(100, 255),math.random(100, 255)))
end

function cube(x,y,z,size)
    local s=size//3
    for x1=-s,s,s do
        for y1=-s,s,s do
            for z1=-s,s,s do
                if (y1~=0 or z1~=0) and (x1~=0 or z1~=0) and (x1~=0 or y1~=0) then
                    if size~=3 then
                        cube(x1+x,y1+y,z1+z,s)
                    else
                        table.insert(tab,vec3(x1+x+50,y1+y+50,z1+z+50))
                    end
                end
            end            
        end
    end
end   